#!/bin/bash

# unmountmedia.sh
#
# Usage: unmountmedia.sh <mount point> <log file>
#
# mount point: the mount point for the media
#
# Return Codes:
# 1 - Error unmounting the media
#
# Author: C. Schuck
#
# Module History
#  00  01/22/2004  P. Provost - Changed to not look in mtab to do umount

MOUNTPOINT=$1
LOGFILE=$2

echo "-> unmountmedia.sh" >> $LOGFILE
echo "Unmounting media at $MOUNTPOINT for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> unmountmedia.sh"
actzTrace "XMDA   F: unmountmedia.sh: Unmounting media at $MOUNTPOINT for `date`"

# Sleep for a few seconds to ensure that Java garbage collection occurs
# before the unmount is attemped. Otherwise, there may be some Java objects
# hanging around that reference paths to the media device that can cause the
# umount command to fail with device busy errors. See MediaDevice.unmount()
# for the explicit calls for Java garbage collector.  
sleep 3 

# Check to see if media is already mounted
#if grep -q $MOUNTPOINT /etc/mtab; then # Media is already mounted
    if ! umount -vf $MOUNTPOINT >> $LOGFILE 2>&1; then
       	echo "Couldn't unmount the media at $MOUNTPOINT... exiting" >> $LOGFILE
        echo "<- unmountmedia.sh" >> $LOGFILE
        echo "" >> $LOGFILE
        actzTrace "XMDA   F: unmountmedia.sh: Couldn't unmount the media at $MOUNTPOINT...exiting."
       	exit 1
    fi
#else
#    echo "No media was found at $MOUNTPOINT in /etc/mtab" >> $LOGFILE
#fi

actzTrace "XMDA   T: <- unmountmedia.sh"

echo "<- unmountmedia.sh" >> $LOGFILE
echo "" >> $LOGFILE

exit 0
